<?php
// app/Models/Desa.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Desa extends Model
{
    protected $table = 'desa';
    
    protected $fillable = [
        'nama_desa', 'kecamatan', 'kabupaten', 'alamat',
        'latitude', 'longitude', 'jumlah_penduduk', 'kebutuhan_air_harian'
    ];

    protected $casts = [
        'latitude' => 'decimal:7',
        'longitude' => 'decimal:7',
    ];

    public function dusun()
    {
        return $this->hasMany(Dusun::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function prediksi()
    {
        return $this->hasMany(Prediksi::class);
    }

    public function laporan()
    {
        return $this->hasMany(Laporan::class);
    }

    public function tangki()
    {
        return $this->hasMany(Tangki::class);
    }
}
